#include <math.h>
#include <lforms.h>
#include <lforms/opengl.h>

#include "../icons/gear.xpm"
#include "../icons/circuit.xpm"
#include "../icons/clock.xpm"
#include "../icons/bag.xpm"
#include "../icons/notes.xpm"
#include "../icons/cmixer.xpm"

enum { TRISTYLE_WIREFRAME, TRISTYLE_FLAT, TRISTYLE_SMOOTH };

static ff_window_t main_frame;
static ff_window_t glbox;
static ff_window_t tri_rot, tri_zoom, tri_style;

static int menu_action_handler(void* btn, ff_event_t* ev, void* data)
{
    char tmp[256];
    ff_window_t subframe = ff_frame(main_frame, "Hi", NULL, 300, 20, FF_NOFLAGS);
    ff_layout(subframe, ff_stack);
    sprintf(tmp, "Menu item '%s' activated", ff_menu_itemtitle(ev->p, ev->z));
    ff_label(subframe, tmp);
    ff_pack(subframe, FF_BOTH);
    ff_enable(main_frame, FF_YES);
    return 1;
}

static int button_action_handler(void* btn, ff_event_t* ev, void* data)
{
    char tmp[256];
    ff_window_t subframe = ff_frame(main_frame, "Hey", NULL, 300, 20, FF_NOFLAGS);
    ff_layout(subframe, ff_stack);
    sprintf(tmp, "Button '%s' pressed", (char*)ff_get(btn, "caption"));
    ff_label(subframe, tmp);
    ff_pack(subframe, FF_BOTH);
    if (!strcmp(ff_get(btn, "caption"), "Left button"))
        ff_enable(main_frame, FF_NO);
    return 1;
}

static int glbox_paint_handler(void* glbox, ff_event_t* ev, void* data)
{
#ifndef LFORMS_NO_OPENGL
    int style = ff_geti(tri_style, "selection");
    float scale = ((float)ff_geti(tri_zoom, "position"))/100.0f;
    glClearColor(0.1f, 0.2f, 0.3f, 1.0f);
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glRotatef((float)ff_geti(tri_rot, "position"), 0, 0, -1);
    glScalef(0.7f*scale, 0.7f*scale, 0.7f*scale);
    glPolygonMode(GL_FRONT_AND_BACK, style == TRISTYLE_WIREFRAME ? GL_LINE : GL_FILL);
    if (style != TRISTYLE_SMOOTH) glColor3f(1, 0.4f, 0.3f);
    glBegin(GL_TRIANGLES);
    if (style == TRISTYLE_SMOOTH) glColor3f(1, 0.4f, 0.3f);
    glVertex2f(0, 1);
    if (style == TRISTYLE_SMOOTH) glColor3f(0.4f, 0.8f, 0.4f);
    glVertex2f(1, -1);
    if (style == TRISTYLE_SMOOTH) glColor3f(0.3f, 0.4f, 1);
    glVertex2f(-1, -1);
    glEnd();
#endif
    return 1;
}

static int tri_rot_change_handler(void* cb, ff_event_t* ev, void* data)
{
    ff_paint(glbox);
    return 1;
}

static int tri_zoom_change_handler(void* cb, ff_event_t* ev, void* data)
{
    ff_paint(glbox);
    return 1;
}

static int tri_style_select_handler(void* cb, ff_event_t* ev, void* data)
{
    ff_paint(glbox);
    return 1;
}

static int set_list_font(void* btn, ff_event_t* ev, void* data)
{
    ff_window_t* children = ff_children(ff_parent(ff_parent(ff_parent(btn))));
    ff_set(children[0], "font", data);
    ff_free(children);
    return 1;
}

static void create_menu(void)
{
#if 1
    ff_window_t menu = ff_popup(main_frame, "Menu");
    ff_menu_add(menu, "Option 1", 1);
    ff_menu_add(menu, "Option 2", 2);
    ff_menu_add(menu, "Blah", 3);
    ff_menu_add(menu, "Bleh", 109);
    ff_menu_add(menu, "Splof", 55);
    ff_menu_add(menu, "Blurg", 33);
    ff_link(menu, FF_ACTION, menu_action_handler, NULL);
#endif
}

static void create_main_frame(void)
{
    ff_window_t box, ibox1, ibox2, iboxgl, glboxframe, glboxcont, btn, bbox, lbox;

    /* Create and setup the form */
    main_frame = ff_mainframe("Little Forms Demo", NULL, 32, 32, FF_INVISIBLE);
    ff_layout(main_frame, ff_border);
    ff_seti(main_frame, "padding-around", 15);

    /* Create a beveled box for the form's center and set the layout to a
     * vertical stack and add a 5px margin around the box */
    box = ff_box(main_frame, "Center area box", NULL);
    ff_set(box, "font", ff_default_font(FF_BOLD_FONT));
    ff_set(box, "foreground", FF_RGB_ATTR(0, 129, 255));
    ff_margin(box, 5, 5, 5, 5);
    ff_layout(box, ff_stack);
    ff_seti(box, "stack-spacing", 5);
    ff_set(box, "stack-align", "center");
    ff_set(box, "stack-anchor", "center");
    ff_set(box, "stack-orientation", "horizontal");
    ff_set(box, "stack-autosize", "same-height");

    /* Create four buttons around the form - the ff_border layout knows
     * where to put them (although this can be overridden with the
     * border-align attribute for each widget */
    ff_button(main_frame, "Top button", button_action_handler, NULL);
    ff_button(main_frame, "Bottom button", button_action_handler, NULL);
    ff_button(main_frame, "Left button", button_action_handler, NULL);
    ff_button(main_frame, "Right button", button_action_handler, NULL);

    /* Create an inner box for the widgets */
    ibox1 = ff_box(box, "Some Widgets", NULL);
    ff_layout(ibox1, ff_stack);
    ff_seti(ibox1, "stack-spacing", 5);
    ff_set(ibox1, "stack-anchor", "top");
    ff_set(ibox1, "stack-autosize", "same-width");

    /* Add some widgets inside the box */
    ff_set(ff_label(ibox1, "Centered label in a stack"), "halign", "center");
    ff_checkbox(ibox1, "A checkbox", FF_FALSE);
    ff_checkbox(ibox1, "Another checkbox", FF_TRUE);
    ff_separator(ibox1, NULL);
    ff_slider(ibox1, 0, 10, 3, FF_YES);
    ff_label(ibox1, "Here comes an editor:");
    /*ed = */ff_editor(ibox1, "This is some text. The\n"
    "editor was made using the\n"
    "ff_editor(parent, text) call.");
    /*ed = ff_editor(ibox1, "This is some text. The\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "editor was made using the\n"
    "ff_editor(parent, text) call.");
    ff_prefsize(ed, 100, 200);*/
    ff_separator(ibox1, NULL);
    ff_label(ibox1, "A field:");
    ff_field(ibox1, "Blah");

    ff_separator(ibox1, NULL);
    ff_set(ff_label(ibox1, "Big font"), "font", ff_default_font(FF_BIG_FONT));
    ff_set(ff_label(ibox1, "Bold font"), "font", ff_default_font(FF_BOLD_FONT));
    ff_set(ff_label(ibox1, "Italic font"), "font", ff_default_font(FF_ITALIC));
    ff_label(ibox1, "Standard font");
    ff_set(ff_label(ibox1, "Small font"), "font", ff_default_font(FF_SMALL_FONT));
    ff_set(ff_label(ibox1, "Monospace font"), "font", ff_default_font(FF_MONOSPACE_FONT));

    ff_separator(ibox1, NULL);
    ff_label(ibox1, "A masked image:");
    ff_image(ibox1, ff_xpm(bag_xpm, NULL, NULL));

    /* Create a box for the buttons */
    bbox = ff_box(ibox1, NULL, "thin-sunken");
    ff_layout(bbox, ff_stack);
    ff_set(bbox, "stack-orientation", "horizontal");
    ff_set(bbox, "stack-align", "center");
    btn = ff_button(bbox, "Bunch", NULL, NULL);
    ff_set(btn, "type", "select");
    ff_set(btn, "bitmap", ff_xpm(gear_xpm, NULL, NULL));
    btn = ff_button(bbox, "of", NULL, NULL);
    ff_set(btn, "type", "select");
    ff_set(btn, "bitmap", ff_xpm(clock_xpm, NULL, NULL));
    btn = ff_button(bbox, "Buttons", NULL, NULL);
    ff_set(btn, "type", "select");
    ff_set(btn, "bitmap", ff_xpm(notes_xpm, NULL, NULL));
    ff_seti(btn, "group", 2);
    btn = ff_button(bbox, "(Yeah!)", NULL, NULL);
    ff_set(btn, "type", "select");
    ff_set(btn, "bitmap", ff_xpm(circuit_xpm, NULL, NULL));
    ff_seti(btn, "group", 2);
    btn = ff_button(bbox, "(Right!)", NULL, NULL);
    ff_set(btn, "type", "select");
    ff_set(btn, "bitmap", ff_xpm(cmixer_xpm, NULL, NULL));
    ff_seti(btn, "group", 2);

    /* Buttons below the box above */
    ff_button(ibox1, "Stacked button", button_action_handler, NULL);
    btn = ff_button(ibox1, "Stacked toggle button", button_action_handler, NULL);
    ff_set(btn, "type", (void*)"toggle");

    /* Create another inner box for the second column */
    ibox2 = ff_box(box, NULL, "none");
    ff_set(ibox2, "stack-align", "fill");
    ff_layout(ibox2, ff_stack);

    /* Create another inner box for the OpenGL box */
    iboxgl = ff_box(ibox2, "Widget with FF_OPENGL flag", NULL);
    ff_layout(iboxgl, ff_stack);
    ff_seti(iboxgl, "stack-noscale", FF_YES);

    /* Create a container for the OpenGL box and the vertical slider */
    glboxcont = ff_box(iboxgl, NULL, "none");
    ff_layout(glboxcont, ff_stack);
    ff_set(glboxcont, "stack-orientation", "horizontal");
    ff_seti(glboxcont, "stack-spacing", 5);

    /* Create the OpenGL box and the box/frame it will contain it */
    glboxframe = ff_box(glboxcont, NULL, "thin-sunken");
    ff_layout(glboxframe, ff_stack);
    glbox = ff_glbox(glboxframe, 320, 320, glbox_paint_handler, NULL);

    /* Triangle zoom slider */
    tri_zoom = ff_slider(glboxcont, 1, 200, 100, FF_NO);
    ff_link(tri_zoom, FF_CHANGE, tri_zoom_change_handler, NULL);

    /* Triangle rotation slider */
    ff_label(iboxgl, "Rotate the triangle with this:");
    tri_rot = ff_slider(iboxgl, 0, 360, 0, FF_YES);
    ff_link(tri_rot, FF_CHANGE, tri_rot_change_handler, NULL);

    /* Render style choice box */
    {
        const char* items[] = {
            "Render a plain wireframe triangle",
            "Render a flat colored triangle",
            "Render a smoothly colored triangle"
        };
        tri_style = ff_choice(iboxgl, items, NULL, 3, 2);
        ff_seti(tri_style, "margin-top", 5);
        ff_link(tri_style, FF_SELECT, tri_style_select_handler, NULL);
    }

    /* Create a box that will contain the list */
    lbox = ff_box(ibox2, "List", NULL);
    ff_set(lbox, "vertical-align", "center");
    ff_layout(lbox, ff_border);
    {
        int i;
        ff_window_t list = ff_list(lbox, NULL, NULL, 0, -1);
        ff_set(list, "border-align", "center");
        for (i=0; i < 64; i++) {
            char item[256];
            sprintf(item, "List item %i", i);
            ff_list_add(list, item, NULL);
        }
        ff_seti(list, "selection", 0);
        /* Font choice */
        {
            ff_window_t btn, box = ff_box(lbox, NULL, "none"), subbox;
            ff_seti(box, "margin-top", 5);
            ff_set(box, "dolt", "ee");
            ff_set(box, "border-align", "bottom");
            ff_layout(box, ff_stack);
            ff_set(box, "stack-orientation", "horizontal");
            ff_set(box, "stack-align", "fill");
            ff_seti(ff_label(box, "Font:"), "stack-noscale", 1);
            subbox = ff_box(box, NULL, "none");
            ff_seti(subbox, "margin-left", 5);
            ff_layout(subbox, ff_stack);
            ff_set(subbox, "stack-orientation", "horizontal");
            ff_set(subbox, "stack-autosize", "same-width");
            ff_set(subbox, "stack-align", "fill");
            btn = ff_button(subbox, "Normal", set_list_font, ff_default_font(FF_STANDARD_FONT));
            ff_set(btn, "type", "select");
            ff_set(btn, "font", ff_default_font(FF_SMALL_FONT));
            btn = ff_button(subbox, "Italic", set_list_font, ff_default_font(FF_ITALIC_FONT));
            ff_set(btn, "type", "select");
            ff_set(btn, "font", ff_default_font(FF_SMALL_FONT));
            ff_seti(btn, "selected", FF_YES);
            btn = ff_button(subbox, "Bold", set_list_font, ff_default_font(FF_BOLD_FONT));
            ff_set(btn, "type", "select");
            ff_set(btn, "font", ff_default_font(FF_SMALL_FONT));
            btn = ff_button(subbox, "Small", set_list_font, ff_default_font(FF_SMALL_FONT));
            ff_set(btn, "type", "select");
            ff_set(btn, "font", ff_default_font(FF_SMALL_FONT));
            btn = ff_button(subbox, "Big", set_list_font, ff_default_font(FF_BIG_FONT));
            ff_set(btn, "type", "select");
            ff_set(btn, "font", ff_default_font(FF_SMALL_FONT));
            btn = ff_button(subbox, "Mono", set_list_font, ff_default_font(FF_MONOSPACE_FONT));
            ff_set(btn, "type", "select");
            ff_set(btn, "font", ff_default_font(FF_SMALL_FONT));
        }
        ff_pack(box, FF_BOTH);
        ff_relayout(ibox2);
    }

    /* Pack the main frame */
    ff_pack(main_frame, FF_BOTH);

    /* Show the main frame */
    ff_show(main_frame, FF_YES);

    /* Create the menu */
    create_menu();
}

int main(int argc, char** argv)
{
    if (!ff_init(argc, argv, "Little Forms Demo")) {
        fprintf(stderr, "Failed to initialize Little Forms\n");
        return 1;
    }

    create_main_frame();

    return ff_run();
}

