#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t status;      /* Label to show the status */

/* Called to paint the window */
static int paint_handler(void* win, ff_event_t* ev, void* data)
{
    char tmp[64];
    int x, y, count = 0;

    /* Get the graphics context to use for painting on the window */
    ff_gc_t gc = ev->p;

    /* Get the bounding box of the damaged area */
    int x1, y1, x2, y2;
    ff_damaged(gc, &x1, &y1, &x2, &y2);

    /* Fill a rectangle in the area with a random color */
    ff_color(gc, FF_RGB(rand()%100 + 100, rand()%100 + 100, rand()%100 + 100));
    ff_fill(gc, x1, y1, x2, y2);

    /* Split the area in 8x8 boxes and check which are inside the
     * damaged area */
    ff_color(gc, 0);
    for (y=y1/8*8; y <= y2; y += 8)
        for (x=x1/8*8 - 1; x <= x2; x += 8)
            if (ff_isdamaged(gc, x, y, x + 8, y + 8)) {
                ff_rect(gc, x, y, x + 8, y + 8);
                count++;
            }

    /* Update status */
    sprintf(tmp, "%i boxes were damaged", count);
    ff_set(status, "caption", tmp);

    /* We handled the event, no need for further processing */
    return FF_YES;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "DamageTest"))
        return 1;
    srand((unsigned)ff_ticks());

    /* Create main frame, start invisible to handle the first paint */
    main_frame = ff_mainframe("Damage Test", NULL,
                              319, 320,
                              FF_INVISIBLE);
    ff_layout(main_frame, ff_border);

    /* Create the status label */
    status = ff_label(main_frame, "");
    ff_set(status, "border-align", "top");

    /* Link the paint event */
    ff_link(main_frame, FF_PAINT, paint_handler, NULL);

    /* Show the window */
    ff_show(main_frame, FF_YES);

    /* Enter main loop */
    return ff_run();
}
