#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t output;      /* A list to place the messages */

/* Called when the main window is double clicked */
static int dblclick_handler(void* win, ff_event_t* ev, void* data)
{
    char tmp[64];
    sprintf(tmp, "Doubleclicked button #%i at %i, %i", ev->z,
                                                       ev->x,
                                                       ev->y);
    ff_list_add(output, tmp, NULL);
    ff_list_select(output, ff_list_items(output) - 1, FF_YES);
    return FF_YES;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "Doubleclick"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Doubleclick Test", NULL,
                              320, 260,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_stack);
    ff_seti(main_frame, "padding-around", 15);

    /* Create the controls */
    ff_label(main_frame, "Doubleclick somewhere in the window");
    output = ff_list(main_frame, NULL, NULL, 0, 0);
    ff_seti(output, "margin-top", 100);
    ff_seti(output, "minimum-height", 100);

    /* Setup the double click handler */
    ff_link(main_frame, FF_DBLCLICK, dblclick_handler, NULL);

    /* Pack the window */
    ff_pack(main_frame, FF_VERTICAL);

    /* Enter main loop */
    return ff_run();
}
