#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */

/* Entry point */
int main(int argc, char** argv)
{
    int i;

    /* Initialize */
    if (!ff_init(argc, argv, "GridExample"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Grid Layout Example", NULL,
                              500, 300,
                              FF_INVISIBLE);    /* Start invisible */

    /* Use the grid layout with 8 columns, horizontal align set to
     * fill (resize all controls to fill the available width) and
     * vertical align set to center */
    ff_layout(main_frame, ff_grid);
    ff_seti(main_frame, "grid-columns", 8);
    ff_set(main_frame, "grid-horizontal-align", "fill");
    ff_set(main_frame, "grid-vertical-align", "center");

    /* Create the controls for the grid */
    for (i=0; i < 61; i++) {
        char cap[16];
        ff_window_t btn;
        sprintf(cap, "%2i", i + 1);
        btn = ff_button(main_frame, cap, NULL, NULL);
        /* Some special cases to try out a few different cell layouts */
        if (i == 8) ff_seti(btn, "grid-column-span", 8);
        if (i == 18) {
            ff_set(btn, "caption", "2 row 3 col span");
            ff_seti(btn, "grid-column-span", 2);
            ff_seti(btn, "grid-row-span", 3);
            ff_seti(btn, "minimum-width", 140);
        }
        if (i == 28) {
            ff_seti(btn, "grid-column-span", 2);
            ff_set(btn, "align-vertical", "center");
            ff_set(btn, "caption", "Vertically centered in cell");
        }
        if (i == 37) ff_seti(btn, "minimum-width", 50);
        if (i == 46) {
            ff_set(btn, "caption", "Bottom");
            ff_set(btn, "align-vertical", "bottom");
            ff_seti(btn, "grid-row-span", 4);
            ff_seti(btn, "minimum-height", 50);
        }
        if (i == 49) {
            ff_set(btn, "align-horizontal", "center");
            ff_set(btn, "caption", "Horizontally centered in cell");
            ff_seti(btn, "grid-column-span", 4);
        }
    }

    /* Pack the window horizontally and vertically and show it */
    ff_pack(main_frame, FF_BOTH);
    ff_show(main_frame, FF_YES);

    /* Enter main loop */
    return ff_run();
}
