#ifndef __LFORMS_H_INCLUDED__
#error Please do not include this file directly. Use #include <lforms.h> instead
#endif

/* Scrollbar part */
typedef enum {
    FF_SBNONE,
    FF_SBARROW1,
    FF_SBARROW2,
    FF_SBBEFORE,
    FF_SBAFTER,
    FF_SBTHUMB
} ff_sbpart_t;

/* Scrollbar information for embedded scrollbars */
typedef struct _ff_sbinfo_t
{
    int x, y, w, h;     /* Area */
    int max, page, pos; /* Value */
    unsigned flags;     /* Flags */
    ff_sbpart_t cap;    /* Captured part (FF_SBNONE=no capture) */
    int capos;          /* Mouse X/Y pos on capture */
    int precapos;       /* Pre-capture position */
    int reserved[5];    /* Reserved for future use */
} ff_sbinfo_t;

/* Will be filled by ff_sbhelp_calc with scrollbar metrics */
typedef struct _ff_sbhcalc_t
{
    int trk;    /* Track size */
    int tb;     /* Thumb begin pos */
    int ts;     /* Thumb size */
    int te;     /* Thumb end pos */
    int btn;    /* Button area size */
    int sz;     /* Full size (w or h) */
    int r[2];   /* Reserved for future use */
} ff_sbhcalc_t;

/* Scrollbar helper functions */
int ff_sbhelp_calc(int x, int y, int w, int h, int max, int page, int pos, unsigned flags, ff_sbhcalc_t* sb);
void ff_sbhelp_draw(ff_gc_t gc, ff_window_t win, int x, int y, int w, int h, int max, int page, int pos, unsigned flags);

/* Embedded scrollbar functions */
void ff_sbinfo_init(ff_sbinfo_t* sb, unsigned flags);
void ff_sbinfo_place(ff_sbinfo_t* sb, ff_window_t win, int x, int y, int w, int h);
void ff_sbinfo_update(ff_sbinfo_t* sb, ff_window_t win);
void ff_sbinfo_paint(ff_sbinfo_t* sb, ff_window_t win, ff_gc_t gc);
void ff_sbinfo_set(ff_sbinfo_t* sb, ff_window_t win, int pos);
ff_sbpart_t ff_sbinfo_part(ff_sbinfo_t* sb, int x, int y);
int ff_sbinfo_press(ff_sbinfo_t* sb, ff_window_t win, int x, int y, int z);
int ff_sbinfo_release(ff_sbinfo_t* sb, ff_window_t win, int x, int y, int z);
int ff_sbinfo_motion(ff_sbinfo_t* sb, ff_window_t win, int x, int y);
int ff_sbinfo_needs_timer(ff_sbinfo_t* sb);
int ff_sbinfo_timer(ff_sbinfo_t* sb, ff_window_t win);

/* Scrollbar widget */
ff_window_t ff_scrollbar(ff_window_t parent, int pagesize, int max, int position, int horizontal);
