#ifndef __LFORMS_WINSYS_H_INCLUDED__
#define __LFORMS_WINSYS_H_INCLUDED__

#ifndef LFORMS_SOURCE_CODE
#warning Unless you know what you are doing, do not use this API directly. Define LFORMS_SOURCE_CODE to get rid of this message.
#endif

/* Common */
void ff_ws_common_init(void);
void ff_ws_common_shutdown(void);
void ff_ws_regwin(void* native, void* wswin);
void ff_ws_unregwin(void* wswin);
void ff_ws_enumreg(void (*proc)(void* native, void* wswin, void* data), void* data);
void* ff_ws_native(void* wswin);
void* ff_ws_wswin(void* native);

/* Lifetime */
int ff_ws_init(int argc, char** argv);
void ff_ws_shutdown(void);
void ff_ws_exit(int exitcode);
void ff_ws_sync(void);
int ff_ws_has_events(void);
int ff_ws_pump_events(void);
void ff_ws_gfx_init(void);
void ff_ws_gfx_shutdown(void);

/* Windows */
void* ff_ws_create_window(void* parent, int x, int y, int width, int height, unsigned flags);
void ff_ws_destroy_window(void* window);
void ff_ws_set_caption(void* window, const char* caption);
void ff_ws_set_icon(void* window, struct _ff_bitmap_t* icon);
void ff_ws_show(void* window, int show);
int ff_ws_shown(void* window);
void ff_ws_set_ffwindow(void* window, ff_window_t ffwindow);
ff_window_t ff_ws_get_ffwindow(void* window);
void ff_ws_move(void* window, int x, int y);
void ff_ws_resize(void* window, int width, int height);
void ff_ws_paint(void* window);
void ff_ws_damage(void* window, int x1, int y1, int x2, int y2);
void ff_ws_damaged(ff_gc_t gc, int* x1, int* y1, int* x2, int* y2);
int ff_ws_isdamaged(ff_gc_t gc, int x1, int y1, int x2, int y2);
void ff_ws_translate(int* x, int* y, void* from, void* to);
void ff_ws_area(void* window, int* x, int* y, int* width, int* height);
void* ff_ws_pick(void* window, int x, int y);
void ff_ws_pointer(int* x, int* y);
void ff_ws_focus(void* window);
int ff_ws_focused(void* window);
void ff_ws_enable(void* window, int enable);
int ff_ws_enabled(void* window);
int ff_ws_timer(void* window, int ms);
void ff_ws_cursor(void* window, ff_uintptr_t cursor);
void ff_ws_pushmodal(void* window, void* target);
void ff_ws_popmodal(void* target);

/* From winsys to lforms */
void ff__destroyed(ff_window_t win);
int ff__sendpaint(ff_window_t win, ff_gc_t gc);
void ff_ws_process_laters(void);

/* X11 specific */
void* ff_ws_x11_display(void);

#endif
