#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <lforms.h>

void ff_lh_prefsize(ff_window_t win, int* w, int* h, unsigned flags)
{
    int cw, ch, got = 0, pw, ph, minw, minh, mw, mh;
    if (!ff_shown(win) && !(flags & FF_LHINVISIBLE)) {
        *w = *h = 0;
        return;
    }
    pw = ff_geti(win, "preferred-width");
    ph = ff_geti(win, "preferred-height");
    minw = ff_geti(win, "minimum-width");
    minh = ff_geti(win, "minimum-height");
    mw = ff_geti(win, "margin-left") + ff_geti(win, "margin-right");
    mh = ff_geti(win, "margin-top") + ff_geti(win, "margin-bottom");
    mw += ff_geti(win, "margin-around")*2;
    mh += ff_geti(win, "margin-around")*2;
    if (pw < minw) pw = minw;
    if (ph < minh) ph = minh;

    if (!pw) {
        ff_area(win, 0, 0, &cw, &ch);
        got = 1;
        pw = cw;
    }

    if (!ph) {
        if (!got) ff_area(win, 0, 0, &cw, &ch);
        ph = ch;
    }

    if (w) *w = pw + mw;
    if (h) *h = ph + mh;
}

void ff_lh_place(ff_window_t win, int x, int y, int w, int h)
{
    int ma, ml, mt, mr, mb, pw, ph, minw, minh;
    const char* alignhor;
    const char* alignvert;
    if (!w || !h) return;
    ma = ff_geti(win, "margin-around");
    ml = ff_geti(win, "margin-left");
    mt = ff_geti(win, "margin-top");
    mr = ff_geti(win, "margin-right");
    mb = ff_geti(win, "margin-bottom");
    alignhor = ff_get(win, "align-horizontal");
    alignvert = ff_get(win, "align-vertical");
    pw = alignhor ? ff_geti(win, "preferred-width") : 0;
    ph = alignvert ? ff_geti(win, "preferred-height") : 0;
    minw = ff_geti(win, "minimum-width");
    minh = ff_geti(win, "minimum-height");
    if (alignhor && pw < minw) pw = minw;
    if (alignvert && ph < minh) ph = minh;
    x += ml + ma;
    y += mt + ma;
    w -= ml + mr + ma*2;
    h -= mt + mb + ma*2;
    if (alignhor && strcmp(alignhor, "fill") && w > pw) {
        if (!strcmp(alignhor, "left")) {
            w = pw;
        } else if (!strcmp(alignhor, "center")) {
            x += (w - pw)/2;
            w = pw;
        } else if (!strcmp(alignhor, "right")) {
            x += w - pw;
            w = pw;
        }
    }
    if (alignvert && strcmp(alignvert, "fill") && h > ph) {
        if (!strcmp(alignvert, "top")) {
            h = ph;
        } else if (!strcmp(alignvert, "center")) {
            y += (h - ph)/2;
            h = ph;
        } else if (!strcmp(alignvert, "bottom")) {
            y += h - ph;
            h = ph;
        }
    }
    ff_place(win, x, y, w, h);
}
