#define LFORMS_SOURCE_CODE
#include <lforms.h>

const unsigned char* ff_dec8(const unsigned char* str, unsigned* value)
{
    if (!(str[0] & 0x80U)) {
        if (value) *value = str[0] & 0x7FU;
        return str + 1;
    }
    if (((str[0] & 0xE0U) == 0xC0U) &&
        ((str[1] & 0xC0U) == 0x80U)) {
        if (value) *value = ((str[0] & 0x1FU) << 6U)|
                             (str[1] & 0x3FU);
        return str + 2;
    }
    if (((str[0] & 0xF0U) == 0xE0U) &&
        ((str[1] & 0xC0U) == 0x80U) &&
        ((str[2] & 0xC0U) == 0x80U)) {
        if (value) *value = ((str[0] & 0x0FU) << 12U)|
                            ((str[1] & 0x3FU) << 6U)|
                             (str[2] & 0x3FU);
        return str + 3;
    }
    if (((str[0] & 0xF8U) == 0xF0U) &&
        ((str[1] & 0xC0U) == 0x80U) &&
        ((str[2] & 0xC0U) == 0x80U) &&
        ((str[3] & 0xC0U) == 0x80U)) {
        if (value) *value = ((str[0] & 0x0FU) << 18U)|
                            ((str[1] & 0x3FU) << 12U)|
                            ((str[2] & 0x3FU) << 6U)|
                             (str[3] & 0x3FU);
        return str + 4;
    }
    return NULL;
}

int ff_enc8(unsigned value, unsigned char* str)
{
    if (value < 0x80U) {
        str[0] = (unsigned char)value;
        return 1;
    } else if (value < 0x800U) {
        str[0] = (unsigned char)(0xC0U|(value >> 6U));
        str[1] = (unsigned char)(0x80U|(value & 0x3FU));
        return 2;
    } else if (value < 0x10000U) {
        if (value >= 0xD800U && value <= 0xDFFFU) return 0;
        str[0] = (unsigned char)(0xE0U|(value >> 12U));
        str[1] = (unsigned char)(0x80U|((value >> 6U) & 0x3FU));
        str[2] = (unsigned char)(0x80U|(value & 0x3FU));
        return 3;
    } else if (value <= 0x10FFFF) {
        str[0] = (unsigned char)(0xF0U|(value >> 18U));
        str[1] = (unsigned char)(0x80U|((value >> 12U) & 0x3FU));
        str[2] = (unsigned char)(0x80U|((value >> 6U) & 0x3FU));
        str[3] = (unsigned char)(0x80U|(value & 0x3FU));
        return 4;
    } else return 0;
}

const unsigned short* ff_dec16(const unsigned short* str, unsigned* value)
{
    if (str[0] < 0xD800U || str[0] > 0xDFFFU) {
        if (value) *value = str[0];
        return str + 1;
    } else if (str[0] >= 0xD800U && str[0] <= 0xDBFFU &&
               str[1] >= 0xDC00U && str[1] <= 0xDFFFU) {
        if (value) *value = (((str[0] - 0xD800U) << 10U)|
                              (str[1] - 0xDC00U)) + 0x10000U;
        return str + 2;
    } else return 0;
}

int ff_enc16(unsigned value, unsigned short* str)
{
    if (value < 0xD800U || (value >= 0xE000U && value <= 0xFFFFU)) {
        *str = (unsigned short)value;
        return 1;
    } else if (value >= 0x10000U && value <= 0x10FFFFU) {
        value -= 0x10000U;
        str[0] = (unsigned short)(0xD800U + ((value >> 10U)&0x3FFU));
        str[1] = (unsigned short)(0xDC00U + (value&0x3FFU));
        return 2;
    } else return 0;
}

unsigned short* ff_8to16(const unsigned char* str)
{
    unsigned short* tmp;
    unsigned short* result;
    int tgt = 0, b;
    unsigned v;
    if (!str) {
        result = malloc(2);
        result[0] = 0;
        return result;
    }
    tmp = malloc(ff_strlen8(str)*2 + 2);
    while ((str = ff_dec8(str, &v))) {
        if (!v) break;
        b = ff_enc16(v, tmp + tgt);
        if (!b) break;
        tgt += b;
    }
    tmp[tgt] = 0;
    result = malloc((size_t)(tgt*2 + 2));
    memcpy(result, tmp, (size_t)(tgt*2 + 2));
    free(tmp);
    return result;
}

unsigned char* ff_16to8(const unsigned short* str)
{
    unsigned char* tmp;
    unsigned char* result;
    int tgt = 0, b;
    unsigned v;
    if (!str) {
        result = malloc(1);
        result[0] = 0;
        return result;
    }
    tmp = malloc(ff_strlen16(str)*4 + 1);
    while ((str = ff_dec16(str, &v))) {
        if (!v) break;
        b = ff_enc8(v, tmp + tgt);
        if (!b) break;
        tgt += b;
    }
    tmp[tgt] = 0;
    result = malloc((size_t)(tgt + 1));
    memcpy(result, tmp, (size_t)(tgt + 1));
    free(tmp);
    return result;
}

int ff_in8seq(unsigned char ch)
{
    return (ch >> 6U) == 2;
}

size_t ff_strlen8(const unsigned char* str)
{
    return strlen((const char*)str);
}

size_t ff_strlen16(const unsigned short* str)
{
    size_t r = 0;
    for (;*str;r++,str++);
    return r;
}

int ff_isascii(const char* str)
{
    if (!str) return FF_YES;
    for (;*str;str++) {
        int v = (int)str[0];
        if (v < 0 || v > 127)
            return FF_NO;
    }
    return FF_YES;
}

char* ff_asciify(const char* str)
{
    size_t len = strlen(str), tgt = 0;
    char* r = malloc(len + 1);
    unsigned v;
    while ((str = (char*)ff_dec8((unsigned char*)str, &v))) {
        if (!v) break;
        r[tgt++] = v > 127 ? '?' : (char)v;
    }
    r[tgt] = 0;
    return r;
}

char* ff_deasciify(const char* str)
{
    size_t i;
    char* r = ff_strdup(str);
    for (i=0; *str; str++,i++) {
        int v = (int)str[0];
        if (v < 0 || v > 127)
            r[i] = '?';
    }
    return r;
}
