#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

char* ff_strdup(const char* s)
{
    if (s) {
        size_t len = strlen(s) + 1;
        char* r = malloc(len);
        memcpy(r, s, len);
        return r;
    } else {
        char* r = malloc(1);
        r[0] = 0;
        return r;
    }
}

void ff_free(void* ptr)
{
    free(ptr);
}

int ff_streq_nocase(const char* a, const char* b)
{
    size_t i = 0;
    while (1) {
        if (tolower(a[i]) != tolower(b[i])) return 0;
        if (!a[i]) break;
        i++;
    }
    return a[i] == b[i];
}

int ff_round_int(float f)
{
    return (int)(f > 0.0f ? f + 0.5f : f - 0.5f);
}

int ff_qsort_strcmp(const void* a, const void* b)
{
    const char** aa = (const char**)a;
    const char** bb = (const char**)b;
    return strcmp(*aa, *bb);
}

int ff_qsort_int(const void* a, const void* b)
{
    const int* aa = (const int*)a;
    const int* bb = (const int*)b;
    return *aa - *bb;
}

int ff_unrepeat(void* base, size_t nmemb, size_t size)
{
    int r = 0;
    for (;nmemb > 1;nmemb--) {
        if (!memcmp(base, (char*)base + size, size)) {
            memmove(base, (char*)base + size, nmemb*(size - 1));
            r++;
        } else base = (char*)base + size;
    }
    return r;
}

int ff_rect_over_rect(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2)
{
        return !(bx1 > ax2 || bx2 < ax1 || by1 > ay2 || by2 < ay1);
}
