unit ClassRegistries;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

type

  { TClassRegistry }

  TClassRegistry = object
  private
    FClasses: array of TClass;
  public
    procedure Register(AClass: TClass);
    procedure Register(AClassArray: array of TClass);
    function Find(AName: string): TClass;
    function Has(AName: string): Boolean; inline;
    function NewInstance(AName: string): TObject;
  end;

var
  ClassRegistry: TClassRegistry;

implementation

{ TClassRegistry }

procedure TClassRegistry.Register(AClass: TClass);
begin
  if Has(AClass.ClassName) then Exit;
  SetLength(FClasses, Length(FClasses) + 1);
  FClasses[High(FClasses)]:=AClass;
end;

procedure TClassRegistry.Register(AClassArray: array of TClass);
var
  I: Integer;
begin
  for I:=Low(AClassArray) to High(AClassArray) do
    Register(AClassArray[I]);
end;

function TClassRegistry.Find(AName: string): TClass;
var
  I: Integer;
begin
  AName:=UpperCase(AName);
  for I:=0 to High(FClasses) do
    if UpperCase(FClasses[I].ClassName)=AName then Exit(FClasses[I]);
  Result:=nil;
end;

function TClassRegistry.Has(AName: string): Boolean;
begin
  Result:=Assigned(Find(AName));
end;

function TClassRegistry.NewInstance(AName: string): TObject;
var
  Cls: TClass;
begin
  Cls:=Find(AName);
  if not Assigned(Cls) then Exit(nil);
  Result:=Cls.NewInstance;
end;

end.

