unit GLUtilities;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Maths, Textures;

procedure DrawWireframeBox(const Box: TAABox);
procedure DrawSolidBox(const Box: TAABox);
procedure DrawSprite(const C, CamRight, CamUp: TVector; const Sprite: TTexture; Size: Double);
procedure DrawSprite(const C, CamRight, CamUp: TVector; SpriteGLTexture: Integer; Size: Double);

implementation

uses
  GL, GLext, UtilMeshData;

procedure DrawWireframeBox(const Box: TAABox);
begin
  glBegin(GL_LINE_STRIP);
  glVertex3d(Box.a.x, Box.a.y, Box.a.z);
  glVertex3d(Box.b.x, Box.a.y, Box.a.z);
  glVertex3d(Box.b.x, Box.a.y, Box.b.z);
  glVertex3d(Box.a.x, Box.a.y, Box.b.z);
  glVertex3d(Box.a.x, Box.a.y, Box.a.z);
  glEnd;
  glBegin(GL_LINE_STRIP);
  glVertex3d(Box.a.x, Box.b.y, Box.a.z);
  glVertex3d(Box.b.x, Box.b.y, Box.a.z);
  glVertex3d(Box.b.x, Box.b.y, Box.b.z);
  glVertex3d(Box.a.x, Box.b.y, Box.b.z);
  glVertex3d(Box.a.x, Box.b.y, Box.a.z);
  glEnd;
  glBegin(GL_LINES);
  glVertex3d(Box.a.x, Box.a.y, Box.a.z);
  glVertex3d(Box.a.x, Box.b.y, Box.a.z);
  glVertex3d(Box.b.x, Box.a.y, Box.a.z);
  glVertex3d(Box.b.x, Box.b.y, Box.a.z);
  glVertex3d(Box.a.x, Box.a.y, Box.b.z);
  glVertex3d(Box.a.x, Box.b.y, Box.b.z);
  glVertex3d(Box.b.x, Box.a.y, Box.b.z);
  glVertex3d(Box.b.x, Box.b.y, Box.b.z);
  glEnd;
end;

procedure DrawSolidBox(const Box: TAABox);
var
  C, E: TVector;
  I: Integer;
begin
  C:=Box.Center;
  E:=Box.Extent;
  I:=0;
  glBegin(GL_TRIANGLES);
  while I < Length(CubeVertices) do begin
    glVertex3f(CubeVertices[I]*E.x + C.x, CubeVertices[I + 1]*E.y + C.y, CubeVertices[I + 2]*E.z + C.z);
    Inc(I, 3);
  end;
  glEnd();
end;

procedure DrawSprite(const C, CamRight, CamUp: TVector; const Sprite: TTexture; Size: Double);
begin
  DrawSprite(C, CamRight, CamUp, Sprite.GLName, Size);
end;

procedure DrawSprite(const C, CamRight, CamUp: TVector; SpriteGLTexture: Integer; Size: Double);
begin
  Size:=Size*0.5;
  glPushAttrib(GL_CURRENT_BIT or GL_ENABLE_BIT or GL_LIGHTING_BIT);
  glDisable(GL_LIGHTING);
  glActiveTexture(GL_TEXTURE1);
  glBindTexture(GL_TEXTURE_2D, 0);
  glActiveTexture(GL_TEXTURE0);
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, SpriteGLTexture);
  glEnable(GL_BLEND);
  glBegin(GL_QUADS);
  glTexCoord2d(1, 0); glVertex3d(C.X + CamRight.X*Size + CamUp.X*Size, C.Y + CamRight.Y*Size + CamUp.Y*Size, C.Z + CamRight.Z*Size + CamUp.Z*Size);
  glTexCoord2d(0, 0); glVertex3d(C.X - CamRight.X*Size + CamUp.X*Size, C.Y - CamRight.Y*Size + CamUp.Y*Size, C.Z - CamRight.Z*Size + CamUp.Z*Size);
  glTexCoord2d(0, 1); glVertex3d(C.X - CamRight.X*Size - CamUp.X*Size, C.Y - CamRight.Y*Size - CamUp.Y*Size, C.Z - CamRight.Z*Size - CamUp.Z*Size);
  glTexCoord2d(1, 1); glVertex3d(C.X + CamRight.X*Size - CamUp.X*Size, C.Y + CamRight.Y*Size - CamUp.Y*Size, C.Z + CamRight.Z*Size - CamUp.Z*Size);
  glEnd;
  glPopAttrib;
end;

end.

