unit UIUtils;

{$mode objfpc}{$H+}

interface

uses
  {GlobalDefines, }Classes, SysUtils, Controls;

procedure ResizeToMaxWidthOf(Controls: array of const);
function ModifiersInShift(Shift: TShiftState): Boolean;

implementation

procedure ResizeToMaxWidthOf(Controls: array of const);
var
  i: Integer;
  Max: Integer;
  First: Boolean;
  Control: TControl;
begin
  Max:=0;
  First:=True;
  for i:=0 to Length(Controls) - 1 do begin
    if (Controls[i].VType <> vtObject) or not (Controls[i].VObject is TControl) then Continue;
    Control:=TControl(Controls[i].VObject);
    if First then
      Max:=Control.Width
    else
      if Max < Control.Width then
        Max:=Control.Width;
    First:=False;
  end;
  for i:=0 to Length(Controls) - 1 do begin
    if (Controls[i].VType <> vtObject) or not (Controls[i].VObject is TControl) then Continue;
    TControl(Controls[i].VObject).AutoSize:=False;
    TControl(Controls[i].VObject).Width:=Max;
  end;
end;

function ModifiersInShift(Shift: TShiftState): Boolean;
begin
  Result:=(ssCtrl in Shift) or
          (ssShift in Shift) or
          (ssAlt in Shift) or
          (ssAltGr in Shift) or
          (ssMeta in Shift) or
          (ssSuper in Shift) or
          (ssHyper in Shift);
end;

end.

